<?php
declare(strict_types=1);

namespace Lookways\SDK\Api;

class Variation extends Api
{

    const API_URL_PRODUCT_EDIT = "api/product/variation";

    const API_URL_PRODUCT_VARIATION_GET = 'api/partner/product/variation';


    public function updatePrice(string $productCode, int $price) : void
    {

        $this->patch(self::API_URL_PRODUCT_EDIT, [
            'storeFrontCode' => $productCode,
            'price' => $price
        ]);



    }


    public function updateVariation(string $variationCode, array $data) : void
    {
        $data['storeFrontCode'] = $variationCode;
        $this->patch(self::API_URL_PRODUCT_EDIT, $data);
    }


    public function getVariationData(string $productCode) : array| null
    {

        return $this->get(self::API_URL_PRODUCT_VARIATION_GET, ['code' => $productCode], authenticated: true)['variation'] ?? null;

    }




}