<?php
declare(strict_types=1);

namespace Lookways\SDK;

use Lookways\SDK\Api\Product;
use Lookways\SDK\Api\Variation;
use Lookways\SDK\Exception\WrongCredentialTypeException;
use Lookways\SDK\Model\ClientConfig;

class Client
{



    public function __construct(
        protected ClientConfig $clientConfig
    )
    {
    }



    public function getBackendUrl() : string
    {

        return $this->clientConfig->getBackendApiUrl();

    }
    


    public function getBearer() : string
    {
        if($this->clientConfig->getCredentialType() != ClientConfig::CREDENTIAL_TYPE_SESSION)
            throw new WrongCredentialTypeException('credential type must be ' . ClientConfig::CREDENTIAL_TYPE_SESSION);
        return $this->clientConfig->getClientCredential();
    }


    public function getProductAPI() : Product
    {
        return new Product($this);
    }

    public function getVariationAPI() : Variation
    {
        return new Variation($this);
    }

}