<?php
declare(strict_types=1);

namespace PrestaShop\Module\Lookwaysplugin\Service;


use Lookways\SDK\Client;

class LookwaysApiService
{

    protected Client $client;

    protected \Lookways\SDK\Model\ClientConfig $clientConfig;


    public function __construct()
    {

        $this->clientConfig = new \Lookways\SDK\Model\ClientConfig(
            backendApiUrl: \LookwaysPlugin::getBackendUrl(),
            clientCredential: \LookwaysPlugin::getApiKey(),
            credentialType: \Lookways\SDK\Model\ClientConfig::CREDENTIAL_TYPE_SESSION
        );

        $this->client = new Client($this->clientConfig);

    }


    public function getSDKClient(): Client
    {
        return $this->client;
    }


}