<?php
declare(strict_types=1);

namespace PrestaShop\Module\Lookwaysplugin\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * @ORM\Table()
 * @ORM\Entity()
 */
class LookwaysProduct
{




    /**
     * @var string
     * @ORM\Id
     * @ORM\Column(name="id", type="string", length=128)
     *
     */
    private string $id;


    /**
     * @var int|null
     * @ORM\Column(name="lookways_product_id", type="integer")
     */
    protected ?int $lookwaysProductId = null;


    /**
     * @var int|null
     * @ORM\Column(name="lookways_variation_id", type="integer")
     */
    protected ?int $lookwaysVariationId = null;


    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId(string $id): void
    {
        $this->id = $id;
    }

    /**
     * @return int|null
     */
    public function getLookwaysProductId(): ?int
    {
        return $this->lookwaysProductId;
    }

    /**
     * @param int|null $lookwaysProductId
     */
    public function setLookwaysProductId(?int $lookwaysProductId): void
    {
        $this->lookwaysProductId = $lookwaysProductId;
    }

    /**
     * @return int|null
     */
    public function getLookwaysVariationId(): ?int
    {
        return $this->lookwaysVariationId;
    }

    /**
     * @param int|null $lookwaysVariationId
     */
    public function setLookwaysVariationId(?int $lookwaysVariationId): void
    {
        $this->lookwaysVariationId = $lookwaysVariationId;
    }



    public function toArray()
    {

        return [

            'id' => $this->getId(),
            'lookways_product_id' => $this->getLookwaysProductId(),
            'lookways_variation_id' => $this->getLookwaysVariationId()
        ];
    }









}