<?php
declare(strict_types=1);




if (!defined('_PS_VERSION_')) {
    exit;
}


$autoloadPath = __DIR__ . '/vendor/autoload.php';
if (file_exists($autoloadPath)) {
    require_once $autoloadPath;
}

require_once __DIR__ . '/sdk/vendor/autoload.php';
//require_once 'vendor/autoload.php';


class LookwaysPlugin extends Module implements \PrestaShop\PrestaShop\Core\Module\WidgetInterface
{

    const INSTALL_SQL_FILE = 'install.sql';

    const CONFIG_LOOKWAYSPLUGIN_FORM_CLASS = 'LOOKWAYSPLUGIN_FORM_CLASS';


    protected \PrestaShop\Module\Lookwaysplugin\Service\LookwaysApiService $apiService;

    protected \PrestaShop\Module\Lookwaysplugin\Service\LookwaysProductService $lookwaysProductService;



    public function __construct()
    {

        $this->name = 'lookwaysplugin';
        $this->tab = 'others';
        $this->version = '0.0.1';
        $this->author = 'Lookways';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '1.7.0.0',
            'max' => '8.99.99',
        ];
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Lookways Integration Plugin');
        $this->description = $this->l('Integratiooooon.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');


        if ($this->isEnabled($this->name)) {

            $this->apiService = new \PrestaShop\Module\Lookwaysplugin\Service\LookwaysApiService();

            $this->lookwaysProductService = new \PrestaShop\Module\Lookwaysplugin\Service\LookwaysProductService(
                $this->getContainer()->get('doctrine.orm.entity_manager'),
                $this->context,
                $this->apiService
            );
        }
    }


    public function install($keep=true)
    {


        if ($keep) {
            if (!file_exists(dirname(__FILE__) . '/' . self::INSTALL_SQL_FILE)) {
                return false;
            } elseif (!$sql = file_get_contents(dirname(__FILE__) . '/' . self::INSTALL_SQL_FILE)) {
                return false;
            }
            $sql = str_replace(['PREFIX_', 'ENGINE_TYPE'], [_DB_PREFIX_, _MYSQL_ENGINE_], $sql);
            $sql = preg_split("/;\s*[\r\n]+/", trim($sql));

            foreach ($sql as $query) {
                if (!Db::getInstance()->execute(trim($query))) {
                    return false;
                }
            }
        }

        return (

            parent::install() &&
            $this->registerHook('displayAdminProductsMainStepLeftColumnMiddle') &&
            $this->registerHook('actionProductSave') &&
            $this->registerHook('displayAdminProductsCombinationBottom') &&
            $this->registerHook('displayProductButtons') &&
            $this->registerHook('displayHeader') &&

            Configuration::updateValue("LOOKWAYSPLUGIN_API_KEY", "") &&
            Configuration::updateValue("LOOKWAYSPLUGIN_BACKEND_URL", "https://api.lookways.io") &&
            Configuration::updateValue(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS, "#add-to-cart-or-refresh")

        );
    }




    public function uninstall($keep=true)
    {

        return ( parent::uninstall() &&
        Configuration::deleteByName("LOOKWAYSPLUGIN_API_KEY") &&
        Configuration::deleteByName("LOOKWAYSPLUGIN_BACKEND_URL") &&
            Configuration::deleteByName(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS) &&
            Db::getInstance()->execute(trim('DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'lookways_product`'))
    );
    }


    public function hookDisplayProductButtons($params)
    {
        return $this->renderWidget('displayProductButtons', $params);
    }


    public function hookDisplayHeader($params)
    {

        $this->context->controller->registerJavascript(
            'lookways-js',
            'https://integration.lookways.io/sdk/frontend/0.0.4/dev/lookways-sdk.iife.js',
            ['server' => 'remote', 'position' => 'bottom', 'priority' => 150 ]
        );
    }

    public static function getApiKey()
    {
        return Configuration::get('LOOKWAYSPLUGIN_API_KEY');
    }


    public static function getBackendUrl()
    {
        return Configuration::get('LOOKWAYSPLUGIN_BACKEND_URL');
    }


    public function hookDisplayAdminProductsMainStepLeftColumnMiddle($params)
    {
        $this->context->smarty->assign(['lookwaysproductstatus' => 'none']);
        return $this->display(__FILE__, 'integrationstatus.tpl');
        // Your code to display the conditional text here
    }

    public function hookDisplayAdminProductsCombinationBottom($params)
    {



        $lookwaysId = $this->lookwaysProductService->prepareLookwaysId((string) $params['id_product'], (string) $params['id_product_attribute']);





        $this->context->smarty->assign(
            [
                'lookwaysproductstatus' => ($this->lookwaysProductService->checkIfIntegrated($lookwaysId)) ? 'Tak' : 'Nie'
            ]
        );

        return $this->display(__FILE__, 'integrationstatus.tpl');

    }


    public function hookActionProductSave($params)
    {
        $product = $params['product'] ?? throw new \Exception("no product");

        $this->lookwaysProductService->updateProduct($product);
    }



    public function getContent()
    {

        $output = '';

        // this part is executed only when the form is submitted
        if (Tools::isSubmit('submit' . $this->name)) {
            // retrieve the value set by the user
            $lookwayApiKey = (string) Tools::getValue('LOOKWAYSPLUGIN_API_KEY');
            $lookwayBackendUrl = (string) Tools::getValue('LOOKWAYSPLUGIN_BACKEND_URL');
            $lookwayFormClass = (string) Tools::getValue(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS);

            // check that the value is valid
            if (empty($lookwayApiKey) || !Validate::isGenericName($lookwayApiKey) || empty($lookwayBackendUrl) || !Validate::isGenericName($lookwayBackendUrl) ||   empty($lookwayFormClass) || !Validate::isGenericName($lookwayFormClass)) {
                // invalid value, show an error
                $output = $this->displayError($this->l('Invalid Configuration value'));
            } else {
                // value is ok, update it and display a confirmation message
                Configuration::updateValue('LOOKWAYSPLUGIN_API_KEY', $lookwayApiKey);
                Configuration::updateValue('LOOKWAYSPLUGIN_BACKEND_URL', $lookwayBackendUrl);
                Configuration::updateValue(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS, $lookwayFormClass);
                $output = $this->displayConfirmation($this->l('Settings updated'));
            }
        }

        // display any message, then the form
        return $output . $this->displayForm();

    }


    public function displayForm()
    {
        // Init Fields form array
        $form = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Ustawienia'),
                ],
                'input' => [
                    [
                        'type' => 'text',
                        'label' => $this->l('Api Key'),
                        'name' => 'LOOKWAYSPLUGIN_API_KEY',
                        'size' => 512,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Backend URL'),
                        'name' => 'LOOKWAYSPLUGIN_BACKEND_URL',
                        'size' => 255,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Product combination form class name'),
                        'name' => self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS,
                        'size' => 255,
                        'required' => true,
                    ],
                ],

                'submit' => [
                    'title' => $this->l('Save'),
                    'class' => 'btn btn-default pull-right',
                ],
            ],
        ];

        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->table = $this->table;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&' . http_build_query(['configure' => $this->name]);
        $helper->submit_action = 'submit' . $this->name;

        // Default language
        $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');

        // Load current value into the form
        $helper->fields_value['LOOKWAYSPLUGIN_API_KEY'] = Tools::getValue('LOOKWAYSPLUGIN_API_KEY', Configuration::get('LOOKWAYSPLUGIN_API_KEY'));
        $helper->fields_value['LOOKWAYSPLUGIN_BACKEND_URL'] = Tools::getValue('LOOKWAYSPLUGIN_BACKEND_URL', Configuration::get('LOOKWAYSPLUGIN_BACKEND_URL'));
        $helper->fields_value[self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS] = Tools::getValue(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS, Configuration::get(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS));

        return $helper->generateForm([$form]);
    }


    public function reset()
    {
        if (!$this->uninstall(false)) {
            return false;
        }
        if (!$this->install(false)) {
            return false;
        }

        return true;
    }


    public function renderWidget($hookName, array $configuration)
    {
        if($hookName === null)
            return null;

        $this->smarty->assign($this->getWidgetVariables($hookName, $configuration));

        return $this->fetch('module:'. $this->name . '/views/templates/hook/avatar.tpl');

    }

    public function getWidgetVariables($hookName, array $configuration)
    {
        $product = $configuration['product'] ?? null;

        if(empty($product))
            return [];

        $product = new Product($product->id);

        $entity = $this->lookwaysProductService->getLookwaysProductEntity(
            $this->lookwaysProductService->getLookwaysId($product) ?? ""
        );

        if(empty($entity))
            return [];

        $variationData = $this->lookwaysProductService->getProductVariationsData($product);
        $productId =  null;
        foreach($variationData as $variation)
        {
            if(!empty($variation['productId']))
            {
                $productId = $variation['productId'];
                break;
            }
        }

        return [
            'containerClass' => 'lookways-avatar-main-container',
            'variationData' => $variationData,
            'formClass' => Configuration::get(self::CONFIG_LOOKWAYSPLUGIN_FORM_CLASS),
            'productId' => $productId

        ];
    }
}